varying vec2 		texcoord;

uniform sampler2D 	dif0,
					noisemap;

#ifdef _HEIGHTMAP_

uniform sampler2D 	bmp0;

#endif					
					
uniform vec2		fresnel0,
					spec0;
uniform vec4		dcolor0,
					scolor0;
uniform vec2		dscale0,
					bscale0;
uniform vec2		dofs0,
					bofs0;
uniform float 		scatterlevel;
uniform float 		scatterRed;
uniform float		wFar;
	
#ifdef ALPHATEST

	uniform float 		alphalevel;
	varying float		alphaFade;
	
#endif

#ifdef PSYSTEM

	varying float 	life;
	varying float	cosa,
			sina;
					
#else

	#ifdef BSET

		varying vec4 pnormal;
		varying vec4 pcolor;

	#else
	
		varying mat3	TBN;
		
	#endif
		
#endif				


#ifdef _HEIGHTMAP_

	uniform sampler2D	baseTex;
	varying vec3	vColor;
	varying float	vSlope;
	varying vec2 	baseCoords;
	
#endif

varying vec4 		curpos,pos,prev;
uniform float		vScale;

uniform float 		fade;

varying vec2 depth;

vec2 encode(vec3 n)
{
	n=normalize(n);
    float f = sqrt(8.0*n.z+8.0);
    return n.xy / f + 0.5;
}

void main()
{
	#ifdef PSYSTEM
	
		if(life<=0.0)
		discard;
			
	#endif

	vec4 	fdcolor,
			fbcolor;
	vec3	fnormal;
	vec2	fspec,
			ffresnel;
			
	fdcolor=texture2D(dif0,texcoord.st*dscale0+dofs0)*dcolor0;
		
	#ifdef ALPHATEST

		#ifdef PSYSTEM
			float alpha=fdcolor.a*life;
			if(alpha<=alphalevel)
				discard;
		#else
			#ifdef BSET
				float alpha=texture2D(noisemap,texcoord.st).r;
				if(alpha>pcolor.w)
					discard;
			#else
				#ifdef MSET
					float alpha=texture2D(noisemap,texcoord.st*5.0).r;
					if(alpha>fade)
						discard;
				#else
					#ifdef _HEIGHTMAP_
					#else
						#ifdef SKINNING
						#else
							#ifndef _NOT_INSTANCED_
								float alpha=texture2D(noisemap,texcoord.st*5.0).r;
								if(alpha>alphaFade)
									discard;
							#else
								float alpha=texture2D(noisemap,texcoord.st*5.0).r;
								if(alpha>fade)
									discard;
							#endif
						#endif
					#endif
				#endif
			#endif
			
			if(fdcolor.a<=alphalevel)
				discard;
		#endif
		
	#endif

	
	#ifdef BSET
	
	#else
		fbcolor=texture2D(bmp0,texcoord.st*bscale0+bofs0);
		fnormal=vec3(0.0,0.0,1.0);//(fbcolor.xyz*2.0-1.0);
	#endif

	ffresnel.y=fresnel0.y*fbcolor.a;

	#ifdef _HEIGHTMAP_
	
		float t=clamp(-pos.z*0.000025,0.0,1.0);
		fbcolor=texture2D(bmp0,texcoord.st*8.0);
		fbcolor.xyz=(fbcolor.xyz*2.0-1.0);
		fnormal=fbcolor.xyz + fnormal;
		vec4 f0=texture2D(dif0,texcoord.st*8.0);
		fdcolor=fdcolor*(1.0-t)+f0*t;
		float invSlope=1.0-vSlope;
		vec4 baseColor=texture2D(baseTex,baseCoords);
		fdcolor.xyz=baseColor.xyz*vSlope + invSlope*fdcolor.xyz;	
		fbcolor.xyz=normalize(fbcolor.xyz+vec3(0.0,0.0,2.0));
		fnormal=fbcolor.xyz*vSlope + invSlope*fnormal;
		ffresnel.y=baseColor.a*vSlope+invSlope*ffresnel.y;
		
	#endif

	// normalize resultant normal
	normalize(fnormal);
	
	#ifdef _HEIGHTMAP_

		fdcolor.rgb*=vColor;
		
	#endif

	gl_FragData[0]=fdcolor;

	#ifdef PSYSTEM
			
		gl_FragData[1].xy=encode(vec3((fnormal.x*cosa)+(fnormal.y*sina),(fnormal.x*sina)-(fnormal.y*cosa),fnormal.z));
			
	#else
		
		#ifdef BSET
			
			gl_FragData[0].xyz = max(gl_FragData[0].xyz*pcolor.xyz,0.0);
			gl_FragData[1].xy = encode(pnormal.xyz);
			
		#else
		
			// normal
			gl_FragData[1].xy=encode(TBN*fnormal.xyz);
			
		#endif
			
	#endif
	
	gl_FragData[1].a=0.0;
	
	// pos
	vec2 vel=((curpos.xy/curpos.w)-(prev.xy/prev.w))*vScale;
	
	// material params
	gl_FragData[2].r=scatterlevel;
	gl_FragData[2].g=ffresnel.y*0.00390625;
	gl_FragData[2].ba=(vel*vec2(0.5))+vec2(0.5);
}
